/*
 * Decompiled with CFR 0.152.
 */
package evercookie;

import evercookie.EvercookieBackend;
import evercookie.EvercookieExploit;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Hashtable;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class EvercookieFileBackend
implements EvercookieBackend {
    private File file;

    public EvercookieFileBackend() {
        if (!EvercookieExploit.getInstance().isJailbroken()) {
            return;
        }
        this.file = new File(System.getProperty("user.home") + File.separator + ".evercookie");
        try {
            if (this.file.createNewFile()) {
                this.save(new Hashtable<String, String>());
            }
            System.out.println("Storing cookie data in " + this.file.getAbsolutePath());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public boolean isAvailable() {
        try {
            return EvercookieExploit.getInstance().isJailbroken() && this.file.exists() && this.file.canRead() && this.file.canWrite();
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void save(Map<String, String> values) {
        if (!this.isAvailable()) {
            return;
        }
        try {
            ObjectOutputStream os = new ObjectOutputStream(new FileOutputStream(this.file));
            try {
                os.writeObject(values);
            }
            finally {
                os.close();
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void load(Map<String, String> data) {
        if (!this.isAvailable()) {
            return;
        }
        try {
            ObjectInputStream is = new ObjectInputStream(new FileInputStream(this.file));
            try {
                Hashtable loaded = (Hashtable)is.readObject();
                data.putAll(loaded);
            }
            finally {
                is.close();
            }
        }
        catch (ClassNotFoundException e) {
            this.save(data);
        }
        catch (EOFException e) {
            this.save(data);
        }
        catch (Throwable e) {
            data.clear();
        }
    }

    @Override
    public void cleanup() {
        if (!this.isAvailable()) {
            return;
        }
        try {
            this.file.delete();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

